﻿using UnityEngine;
using UnityEditor;
using System.Collections;
using FullControl.Tx.GameLogic;
using FullControl.Tx.View;

namespace FullControl.Tx.LevelEditor
{
	[CustomEditor(typeof(TriggerView))]
	public class TriggerEditor : AssetViewEditor
	{
		#region  	-- Constructor, enabler, initter, destructor, disabler
		protected override void OnEnable ()
		{
			base.OnEnable ();
			triggerView = target as TriggerView;
			triggerProperty = serializedObject.FindProperty("trigger");
			runOnlyOnce = triggerProperty.FindPropertyRelative("runOnlyOnce");
			conditionScript = triggerProperty.FindPropertyRelative("conditionScript");
			eventType = triggerProperty.FindPropertyRelative("eventType");
			effectScript = triggerProperty.FindPropertyRelative("effectScript");
			enabled = triggerProperty.FindPropertyRelative("enabled");
			zones = serializedObject.FindProperty("tileZones");
		}

		#endregion
	
		#region  	-- Private Fields and Properties

		TriggerView triggerView;
		SerializedProperty triggerProperty;
		SerializedProperty runOnlyOnce;
		SerializedProperty conditionScript;
		SerializedProperty eventType;
		SerializedProperty effectScript;
		SerializedProperty enabled;
		SerializedProperty zones;
		bool editorOpen = true;
		bool zonesOpen = true;

		#endregion
	
		#region  	-- Private Methods
		#endregion
	
		#region  	-- Public Properties
		#endregion
	
		#region  	-- Public Methods
		public static void BaseTriggerEditor (SerializedProperty enabled, SerializedProperty runOnlyOnce, SerializedProperty conditionScript, SerializedProperty effectScript)
		{
			EditorGUILayout.PropertyField(enabled);
			EditorGUILayout.PrefixLabel("Condition script:");
			EditorGUI.indentLevel++;
			string conditionScriptTemp = EditorGUILayout.TextArea(conditionScript.stringValue, GUILayout.MinHeight(100));
			if (conditionScriptTemp!=conditionScript.stringValue)
			{
				conditionScript.stringValue = conditionScriptTemp;
			}
			
			EditorGUI.indentLevel--;
			EditorGUILayout.PrefixLabel("Effect script:");
			EditorGUI.indentLevel++;
			string effectScriptTmp = EditorGUILayout.TextArea(effectScript.stringValue, GUILayout.MinHeight(100));
			if (effectScriptTmp!=effectScript.stringValue)
			{
				effectScript.stringValue = effectScriptTmp;
			}
			EditorGUILayout.PropertyField(runOnlyOnce);
			EditorGUI.indentLevel--;
			
		}
		#endregion

		#region  	-- Events and delegates

		protected override void OnSceneInspectorGUI ()
		{
			base.OnSceneInspectorGUI ();

			editorOpen = EditorGUILayout.Foldout(editorOpen, "Trigger properties");

			if (!editorOpen) return;
			EditorGUILayout.PropertyField(eventType);

			BaseTriggerEditor(enabled, runOnlyOnce, conditionScript, effectScript);

			if (triggerView.trigger.eventType == FullControl.Tx.GameLogic.EventType.OnZoneEnter)
			{
				zonesOpen = EditorHelper.ArreayEditor (zones, "Linked zones", zonesOpen);
			}

			/*EditorGUILayout.PropertyField(enabled);
			EditorGUILayout.PropertyField(runOnlyOnce);
			EditorGUILayout.PropertyField(eventType);
			EditorGUILayout.PrefixLabel("Condition script:");
			EditorGUI.indentLevel = 1;
			string conditionScriptTemp = EditorGUILayout.TextArea(conditionScript.stringValue, GUILayout.MinHeight(100));
			if (conditionScriptTemp!=conditionScript.stringValue)
			{
				conditionScript.stringValue = conditionScriptTemp;
			}

			EditorGUI.indentLevel = 0;
			EditorGUILayout.PrefixLabel("Effect script:");
			EditorGUI.indentLevel = 1;
			string effectScriptTmp = EditorGUILayout.TextArea(effectScript.stringValue, GUILayout.MinHeight(100));
			if (effectScriptTmp!=effectScript.stringValue)
			{
				effectScript.stringValue = effectScriptTmp;
			}

			if (triggerView.trigger.eventType == FullControl.Tx.GameLogic.EventType.OnZoneEnter)
			{
				zonesOpen = EditorHelper.ArreayEditor (zones, "Linked zones", zonesOpen);
				//EditorGUILayout.PropertyField(zones);
			}*/

			//serializedObject.ApplyModifiedProperties();
		}
			
		/*protected override void OnProjectInspectorGUI ()
		{
			base.OnProjectInspectorGUI ();
		}*/

		#endregion
	}
}
